<?php
/**
 * Module Library: Tabs Module Preset Attributes Map
 *
 * @package Divi
 * @since ??
 */

namespace ET\Builder\Packages\ModuleLibrary\Tabs;

use ET\Builder\Packages\Module\Options\Loop\LoopPresetAttrsMap;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}


/**
 * Class TabsPresetAttrsMap
 *
 * @since ??
 *
 * @package ET\Builder\Packages\ModuleLibrary\Tabs
 */
class TabsPresetAttrsMap {
	/**
	 * Get the preset attributes map for the Tabs module.
	 *
	 * @since ??
	 *
	 * @param array  $map         The preset attributes map.
	 * @param string $module_name The module name.
	 *
	 * @return array
	 */
	public static function get_map( array $map, string $module_name ) {
		if ( 'divi/tabs' !== $module_name ) {
			return $map;
		}

		$loop_preset_attrs = LoopPresetAttrsMap::get_map( 'module.advanced.loop' );

		return array_merge(
			[
				'module.advanced.link__url'                => [
					'attrName' => 'module.advanced.link',
					'preset'   => 'content',
					'subName'  => 'url',
				],
				'module.advanced.link__target'             => [
					'attrName' => 'module.advanced.link',
					'preset'   => 'content',
					'subName'  => 'target',
				],
				'content.decoration.background__color'     => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'content.decoration.background__gradient.stops' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'gradient.stops',
				],
				'content.decoration.background__gradient.enabled' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'gradient.enabled',
				],
				'content.decoration.background__gradient.type' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'gradient.type',
				],
				'content.decoration.background__gradient.direction' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'gradient.direction',
				],
				'content.decoration.background__gradient.directionRadial' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'gradient.directionRadial',
				],
				'content.decoration.background__gradient.repeat' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'gradient.repeat',
				],
				'content.decoration.background__gradient.length' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'gradient.length',
				],
				'content.decoration.background__gradient.overlaysImage' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'gradient.overlaysImage',
				],
				'content.decoration.background__image.url' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'image.url',
				],
				'content.decoration.background__image.parallax.enabled' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html', 'script' ],
					'subName'  => 'image.parallax.enabled',
				],
				'content.decoration.background__image.parallax.method' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'image.parallax.method',
				],
				'content.decoration.background__image.size' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'image.size',
				],
				'content.decoration.background__image.width' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'image.width',
				],
				'content.decoration.background__image.height' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'image.height',
				],
				'content.decoration.background__image.position' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'image.position',
				],
				'content.decoration.background__image.horizontalOffset' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'image.horizontalOffset',
				],
				'content.decoration.background__image.verticalOffset' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'image.verticalOffset',
				],
				'content.decoration.background__image.repeat' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'image.repeat',
				],
				'content.decoration.background__image.blend' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'image.blend',
				],
				'content.decoration.background__video.mp4' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'html' ],
					'subName'  => 'video.mp4',
				],
				'content.decoration.background__video.webm' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'html' ],
					'subName'  => 'video.webm',
				],
				'content.decoration.background__video.width' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'html' ],
					'subName'  => 'video.width',
				],
				'content.decoration.background__video.height' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'html' ],
					'subName'  => 'video.height',
				],
				'content.decoration.background__video.allowPlayerPause' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'html' ],
					'subName'  => 'video.allowPlayerPause',
				],
				'content.decoration.background__video.pauseOutsideViewport' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'html' ],
					'subName'  => 'video.pauseOutsideViewport',
				],
				'content.decoration.background__pattern.style' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'pattern.style',
				],
				'content.decoration.background__pattern.enabled' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'pattern.enabled',
				],
				'content.decoration.background__pattern.color' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'pattern.color',
				],
				'content.decoration.background__pattern.transform' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'pattern.transform',
				],
				'content.decoration.background__pattern.size' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'pattern.size',
				],
				'content.decoration.background__pattern.width' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'pattern.width',
				],
				'content.decoration.background__pattern.height' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'pattern.height',
				],
				'content.decoration.background__pattern.repeatOrigin' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'pattern.repeatOrigin',
				],
				'content.decoration.background__pattern.horizontalOffset' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'pattern.horizontalOffset',
				],
				'content.decoration.background__pattern.verticalOffset' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'pattern.verticalOffset',
				],
				'content.decoration.background__pattern.repeat' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'pattern.repeat',
				],
				'content.decoration.background__pattern.blend' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'pattern.blend',
				],
				'content.decoration.background__mask.style' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'mask.style',
				],
				'content.decoration.background__mask.enabled' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'mask.enabled',
				],
				'content.decoration.background__mask.color' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style', 'html' ],
					'subName'  => 'mask.color',
				],
				'content.decoration.background__mask.transform' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'mask.transform',
				],
				'content.decoration.background__mask.aspectRatio' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'mask.aspectRatio',
				],
				'content.decoration.background__mask.size' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'mask.size',
				],
				'content.decoration.background__mask.width' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'mask.width',
				],
				'content.decoration.background__mask.height' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'mask.height',
				],
				'content.decoration.background__mask.position' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'mask.position',
				],
				'content.decoration.background__mask.horizontalOffset' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'mask.horizontalOffset',
				],
				'content.decoration.background__mask.verticalOffset' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'mask.verticalOffset',
				],
				'content.decoration.background__mask.blend' => [
					'attrName' => 'content.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'mask.blend',
				],
				'module.meta.adminLabel'                   => [
					'attrName' => 'module.meta.adminLabel',
					'preset'   => 'meta',
				],
				'content.decoration.bodyFont.body.font__family' => [
					'attrName' => 'content.decoration.bodyFont.body.font',
					'preset'   => [ 'style' ],
					'subName'  => 'family',
				],
				'content.decoration.bodyFont.body.font__weight' => [
					'attrName' => 'content.decoration.bodyFont.body.font',
					'preset'   => [ 'style' ],
					'subName'  => 'weight',
				],
				'content.decoration.bodyFont.body.font__style' => [
					'attrName' => 'content.decoration.bodyFont.body.font',
					'preset'   => [ 'style' ],
					'subName'  => 'style',
				],
				'content.decoration.bodyFont.body.font__lineColor' => [
					'attrName' => 'content.decoration.bodyFont.body.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineColor',
				],
				'content.decoration.bodyFont.body.font__lineStyle' => [
					'attrName' => 'content.decoration.bodyFont.body.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineStyle',
				],
				'content.decoration.bodyFont.body.font__textAlign' => [
					'attrName' => 'content.decoration.bodyFont.body.font',
					'preset'   => [ 'style' ],
					'subName'  => 'textAlign',
				],
				'content.decoration.bodyFont.body.font__color' => [
					'attrName' => 'content.decoration.bodyFont.body.font',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'content.decoration.bodyFont.body.font__size' => [
					'attrName' => 'content.decoration.bodyFont.body.font',
					'preset'   => [ 'style' ],
					'subName'  => 'size',
				],
				'content.decoration.bodyFont.body.font__letterSpacing' => [
					'attrName' => 'content.decoration.bodyFont.body.font',
					'preset'   => [ 'style' ],
					'subName'  => 'letterSpacing',
				],
				'content.decoration.bodyFont.body.font__lineHeight' => [
					'attrName' => 'content.decoration.bodyFont.body.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineHeight',
				],
				'content.decoration.bodyFont.body.textShadow__style' => [
					'attrName' => 'content.decoration.bodyFont.body.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'style',
				],
				'content.decoration.bodyFont.body.textShadow__horizontal' => [
					'attrName' => 'content.decoration.bodyFont.body.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'horizontal',
				],
				'content.decoration.bodyFont.body.textShadow__vertical' => [
					'attrName' => 'content.decoration.bodyFont.body.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'vertical',
				],
				'content.decoration.bodyFont.body.textShadow__blur' => [
					'attrName' => 'content.decoration.bodyFont.body.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'blur',
				],
				'content.decoration.bodyFont.body.textShadow__color' => [
					'attrName' => 'content.decoration.bodyFont.body.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'content.decoration.bodyFont.link.font__family' => [
					'attrName' => 'content.decoration.bodyFont.link.font',
					'preset'   => [ 'style' ],
					'subName'  => 'family',
				],
				'content.decoration.bodyFont.link.font__weight' => [
					'attrName' => 'content.decoration.bodyFont.link.font',
					'preset'   => [ 'style' ],
					'subName'  => 'weight',
				],
				'content.decoration.bodyFont.link.font__style' => [
					'attrName' => 'content.decoration.bodyFont.link.font',
					'preset'   => [ 'style' ],
					'subName'  => 'style',
				],
				'content.decoration.bodyFont.link.font__lineColor' => [
					'attrName' => 'content.decoration.bodyFont.link.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineColor',
				],
				'content.decoration.bodyFont.link.font__lineStyle' => [
					'attrName' => 'content.decoration.bodyFont.link.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineStyle',
				],
				'content.decoration.bodyFont.link.font__textAlign' => [
					'attrName' => 'content.decoration.bodyFont.link.font',
					'preset'   => [ 'style' ],
					'subName'  => 'textAlign',
				],
				'content.decoration.bodyFont.link.font__color' => [
					'attrName' => 'content.decoration.bodyFont.link.font',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'content.decoration.bodyFont.link.font__size' => [
					'attrName' => 'content.decoration.bodyFont.link.font',
					'preset'   => [ 'style' ],
					'subName'  => 'size',
				],
				'content.decoration.bodyFont.link.font__letterSpacing' => [
					'attrName' => 'content.decoration.bodyFont.link.font',
					'preset'   => [ 'style' ],
					'subName'  => 'letterSpacing',
				],
				'content.decoration.bodyFont.link.font__lineHeight' => [
					'attrName' => 'content.decoration.bodyFont.link.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineHeight',
				],
				'content.decoration.bodyFont.link.textShadow__style' => [
					'attrName' => 'content.decoration.bodyFont.link.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'style',
				],
				'content.decoration.bodyFont.link.textShadow__horizontal' => [
					'attrName' => 'content.decoration.bodyFont.link.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'horizontal',
				],
				'content.decoration.bodyFont.link.textShadow__vertical' => [
					'attrName' => 'content.decoration.bodyFont.link.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'vertical',
				],
				'content.decoration.bodyFont.link.textShadow__blur' => [
					'attrName' => 'content.decoration.bodyFont.link.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'blur',
				],
				'content.decoration.bodyFont.link.textShadow__color' => [
					'attrName' => 'content.decoration.bodyFont.link.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'content.decoration.bodyFont.ul.font__family' => [
					'attrName' => 'content.decoration.bodyFont.ul.font',
					'preset'   => [ 'style' ],
					'subName'  => 'family',
				],
				'content.decoration.bodyFont.ul.font__weight' => [
					'attrName' => 'content.decoration.bodyFont.ul.font',
					'preset'   => [ 'style' ],
					'subName'  => 'weight',
				],
				'content.decoration.bodyFont.ul.font__style' => [
					'attrName' => 'content.decoration.bodyFont.ul.font',
					'preset'   => [ 'style' ],
					'subName'  => 'style',
				],
				'content.decoration.bodyFont.ul.font__lineColor' => [
					'attrName' => 'content.decoration.bodyFont.ul.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineColor',
				],
				'content.decoration.bodyFont.ul.font__lineStyle' => [
					'attrName' => 'content.decoration.bodyFont.ul.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineStyle',
				],
				'content.decoration.bodyFont.ul.font__textAlign' => [
					'attrName' => 'content.decoration.bodyFont.ul.font',
					'preset'   => [ 'style' ],
					'subName'  => 'textAlign',
				],
				'content.decoration.bodyFont.ul.font__color' => [
					'attrName' => 'content.decoration.bodyFont.ul.font',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'content.decoration.bodyFont.ul.font__size' => [
					'attrName' => 'content.decoration.bodyFont.ul.font',
					'preset'   => [ 'style' ],
					'subName'  => 'size',
				],
				'content.decoration.bodyFont.ul.font__letterSpacing' => [
					'attrName' => 'content.decoration.bodyFont.ul.font',
					'preset'   => [ 'style' ],
					'subName'  => 'letterSpacing',
				],
				'content.decoration.bodyFont.ul.font__lineHeight' => [
					'attrName' => 'content.decoration.bodyFont.ul.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineHeight',
				],
				'content.decoration.bodyFont.ul.textShadow__style' => [
					'attrName' => 'content.decoration.bodyFont.ul.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'style',
				],
				'content.decoration.bodyFont.ul.textShadow__horizontal' => [
					'attrName' => 'content.decoration.bodyFont.ul.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'horizontal',
				],
				'content.decoration.bodyFont.ul.textShadow__vertical' => [
					'attrName' => 'content.decoration.bodyFont.ul.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'vertical',
				],
				'content.decoration.bodyFont.ul.textShadow__blur' => [
					'attrName' => 'content.decoration.bodyFont.ul.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'blur',
				],
				'content.decoration.bodyFont.ul.textShadow__color' => [
					'attrName' => 'content.decoration.bodyFont.ul.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'content.decoration.bodyFont.ul.list__type' => [
					'attrName' => 'content.decoration.bodyFont.ul.list',
					'preset'   => [ 'style' ],
					'subName'  => 'type',
				],
				'content.decoration.bodyFont.ul.list__position' => [
					'attrName' => 'content.decoration.bodyFont.ul.list',
					'preset'   => [ 'style' ],
					'subName'  => 'position',
				],
				'content.decoration.bodyFont.ul.list__itemIndent' => [
					'attrName' => 'content.decoration.bodyFont.ul.list',
					'preset'   => [ 'style' ],
					'subName'  => 'itemIndent',
				],
				'content.decoration.bodyFont.ol.font__family' => [
					'attrName' => 'content.decoration.bodyFont.ol.font',
					'preset'   => [ 'style' ],
					'subName'  => 'family',
				],
				'content.decoration.bodyFont.ol.font__weight' => [
					'attrName' => 'content.decoration.bodyFont.ol.font',
					'preset'   => [ 'style' ],
					'subName'  => 'weight',
				],
				'content.decoration.bodyFont.ol.font__style' => [
					'attrName' => 'content.decoration.bodyFont.ol.font',
					'preset'   => [ 'style' ],
					'subName'  => 'style',
				],
				'content.decoration.bodyFont.ol.font__lineColor' => [
					'attrName' => 'content.decoration.bodyFont.ol.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineColor',
				],
				'content.decoration.bodyFont.ol.font__lineStyle' => [
					'attrName' => 'content.decoration.bodyFont.ol.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineStyle',
				],
				'content.decoration.bodyFont.ol.font__textAlign' => [
					'attrName' => 'content.decoration.bodyFont.ol.font',
					'preset'   => [ 'style' ],
					'subName'  => 'textAlign',
				],
				'content.decoration.bodyFont.ol.font__color' => [
					'attrName' => 'content.decoration.bodyFont.ol.font',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'content.decoration.bodyFont.ol.font__size' => [
					'attrName' => 'content.decoration.bodyFont.ol.font',
					'preset'   => [ 'style' ],
					'subName'  => 'size',
				],
				'content.decoration.bodyFont.ol.font__letterSpacing' => [
					'attrName' => 'content.decoration.bodyFont.ol.font',
					'preset'   => [ 'style' ],
					'subName'  => 'letterSpacing',
				],
				'content.decoration.bodyFont.ol.font__lineHeight' => [
					'attrName' => 'content.decoration.bodyFont.ol.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineHeight',
				],
				'content.decoration.bodyFont.ol.textShadow__style' => [
					'attrName' => 'content.decoration.bodyFont.ol.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'style',
				],
				'content.decoration.bodyFont.ol.textShadow__horizontal' => [
					'attrName' => 'content.decoration.bodyFont.ol.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'horizontal',
				],
				'content.decoration.bodyFont.ol.textShadow__vertical' => [
					'attrName' => 'content.decoration.bodyFont.ol.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'vertical',
				],
				'content.decoration.bodyFont.ol.textShadow__blur' => [
					'attrName' => 'content.decoration.bodyFont.ol.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'blur',
				],
				'content.decoration.bodyFont.ol.textShadow__color' => [
					'attrName' => 'content.decoration.bodyFont.ol.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'content.decoration.bodyFont.ol.list__type' => [
					'attrName' => 'content.decoration.bodyFont.ol.list',
					'preset'   => [ 'style' ],
					'subName'  => 'type',
				],
				'content.decoration.bodyFont.ol.list__position' => [
					'attrName' => 'content.decoration.bodyFont.ol.list',
					'preset'   => [ 'style' ],
					'subName'  => 'position',
				],
				'content.decoration.bodyFont.ol.list__itemIndent' => [
					'attrName' => 'content.decoration.bodyFont.ol.list',
					'preset'   => [ 'style' ],
					'subName'  => 'itemIndent',
				],
				'content.decoration.bodyFont.quote.font__family' => [
					'attrName' => 'content.decoration.bodyFont.quote.font',
					'preset'   => [ 'style' ],
					'subName'  => 'family',
				],
				'content.decoration.bodyFont.quote.font__weight' => [
					'attrName' => 'content.decoration.bodyFont.quote.font',
					'preset'   => [ 'style' ],
					'subName'  => 'weight',
				],
				'content.decoration.bodyFont.quote.font__style' => [
					'attrName' => 'content.decoration.bodyFont.quote.font',
					'preset'   => [ 'style' ],
					'subName'  => 'style',
				],
				'content.decoration.bodyFont.quote.font__lineColor' => [
					'attrName' => 'content.decoration.bodyFont.quote.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineColor',
				],
				'content.decoration.bodyFont.quote.font__lineStyle' => [
					'attrName' => 'content.decoration.bodyFont.quote.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineStyle',
				],
				'content.decoration.bodyFont.quote.font__textAlign' => [
					'attrName' => 'content.decoration.bodyFont.quote.font',
					'preset'   => [ 'style' ],
					'subName'  => 'textAlign',
				],
				'content.decoration.bodyFont.quote.font__color' => [
					'attrName' => 'content.decoration.bodyFont.quote.font',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'content.decoration.bodyFont.quote.font__size' => [
					'attrName' => 'content.decoration.bodyFont.quote.font',
					'preset'   => [ 'style' ],
					'subName'  => 'size',
				],
				'content.decoration.bodyFont.quote.font__letterSpacing' => [
					'attrName' => 'content.decoration.bodyFont.quote.font',
					'preset'   => [ 'style' ],
					'subName'  => 'letterSpacing',
				],
				'content.decoration.bodyFont.quote.font__lineHeight' => [
					'attrName' => 'content.decoration.bodyFont.quote.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineHeight',
				],
				'content.decoration.bodyFont.quote.textShadow__style' => [
					'attrName' => 'content.decoration.bodyFont.quote.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'style',
				],
				'content.decoration.bodyFont.quote.textShadow__horizontal' => [
					'attrName' => 'content.decoration.bodyFont.quote.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'horizontal',
				],
				'content.decoration.bodyFont.quote.textShadow__vertical' => [
					'attrName' => 'content.decoration.bodyFont.quote.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'vertical',
				],
				'content.decoration.bodyFont.quote.textShadow__blur' => [
					'attrName' => 'content.decoration.bodyFont.quote.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'blur',
				],
				'content.decoration.bodyFont.quote.textShadow__color' => [
					'attrName' => 'content.decoration.bodyFont.quote.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'content.decoration.bodyFont.quote.border__styles.left.width' => [
					'attrName' => 'content.decoration.bodyFont.quote.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.left.width',
				],
				'content.decoration.bodyFont.quote.border__styles.left.color' => [
					'attrName' => 'content.decoration.bodyFont.quote.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.left.color',
				],
				'activeTab.decoration.background__color'   => [
					'attrName' => 'activeTab.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'inactiveTab.decoration.background__color' => [
					'attrName' => 'inactiveTab.decoration.background',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'activeTab.decoration.font.font__color'    => [
					'attrName' => 'activeTab.decoration.font.font',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'tab.decoration.font.font__family'         => [
					'attrName' => 'tab.decoration.font.font',
					'preset'   => [ 'style' ],
					'subName'  => 'family',
				],
				'tab.decoration.font.font__weight'         => [
					'attrName' => 'tab.decoration.font.font',
					'preset'   => [ 'style' ],
					'subName'  => 'weight',
				],
				'tab.decoration.font.font__style'          => [
					'attrName' => 'tab.decoration.font.font',
					'preset'   => [ 'style' ],
					'subName'  => 'style',
				],
				'tab.decoration.font.font__lineColor'      => [
					'attrName' => 'tab.decoration.font.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineColor',
				],
				'tab.decoration.font.font__lineStyle'      => [
					'attrName' => 'tab.decoration.font.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineStyle',
				],
				'tab.decoration.font.font__color'          => [
					'attrName' => 'tab.decoration.font.font',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'tab.decoration.font.font__size'           => [
					'attrName' => 'tab.decoration.font.font',
					'preset'   => [ 'style' ],
					'subName'  => 'size',
				],
				'tab.decoration.font.font__letterSpacing'  => [
					'attrName' => 'tab.decoration.font.font',
					'preset'   => [ 'style' ],
					'subName'  => 'letterSpacing',
				],
				'tab.decoration.font.font__lineHeight'     => [
					'attrName' => 'tab.decoration.font.font',
					'preset'   => [ 'style' ],
					'subName'  => 'lineHeight',
				],
				'tab.decoration.font.textShadow__style'    => [
					'attrName' => 'tab.decoration.font.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'style',
				],
				'tab.decoration.font.textShadow__horizontal' => [
					'attrName' => 'tab.decoration.font.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'horizontal',
				],
				'tab.decoration.font.textShadow__vertical' => [
					'attrName' => 'tab.decoration.font.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'vertical',
				],
				'tab.decoration.font.textShadow__blur'     => [
					'attrName' => 'tab.decoration.font.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'blur',
				],
				'tab.decoration.font.textShadow__color'    => [
					'attrName' => 'tab.decoration.font.textShadow',
					'preset'   => [ 'style' ],
					'subName'  => 'color',
				],
				'module.decoration.sizing__width'          => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'width',
				],
				'module.decoration.sizing__maxWidth'       => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'maxWidth',
				],
				'module.decoration.sizing__flexType'       => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'html' ],
					'subName'  => 'flexType',
				],
				'module.decoration.sizing__alignSelf'      => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'alignSelf',
				],
				'module.decoration.sizing__flexGrow'       => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'flexGrow',
				],
				'module.decoration.sizing__flexShrink'     => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'flexShrink',
				],
				'module.decoration.sizing__gridAlignSelf'  => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'gridAlignSelf',
				],
				'module.decoration.sizing__gridColumnSpan' => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'gridColumnSpan',
				],
				'module.decoration.sizing__gridColumnStart' => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'gridColumnStart',
				],
				'module.decoration.sizing__gridJustifySelf' => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'gridJustifySelf',
				],
				'module.decoration.sizing__gridRowSpan'    => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'gridRowSpan',
				],
				'module.decoration.sizing__gridRowStart'   => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'gridRowStart',
				],
				'module.decoration.sizing__gridColumnEnd'  => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'gridColumnEnd',
				],
				'module.decoration.sizing__gridRowEnd'     => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'gridRowEnd',
				],
				'module.decoration.sizing__size'           => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'size',
				],
				'module.decoration.sizing__alignment'      => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'alignment',
				],
				'module.decoration.sizing__minHeight'      => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'minHeight',
				],
				'module.decoration.sizing__height'         => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'height',
				],
				'module.decoration.sizing__maxHeight'      => [
					'attrName' => 'module.decoration.sizing',
					'preset'   => [ 'style' ],
					'subName'  => 'maxHeight',
				],
				'module.decoration.spacing__margin'        => [
					'attrName' => 'module.decoration.spacing',
					'preset'   => [ 'style' ],
					'subName'  => 'margin',
				],
				'module.decoration.spacing__padding'       => [
					'attrName' => 'module.decoration.spacing',
					'preset'   => [ 'style' ],
					'subName'  => 'padding',
				],
				'module.decoration.border__radius'         => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'radius',
				],
				'module.decoration.border__styles'         => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles',
				],
				'module.decoration.border__styles.all.width' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.all.width',
				],
				'module.decoration.border__styles.top.width' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.top.width',
				],
				'module.decoration.border__styles.right.width' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.right.width',
				],
				'module.decoration.border__styles.bottom.width' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.bottom.width',
				],
				'module.decoration.border__styles.left.width' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.left.width',
				],
				'module.decoration.border__styles.all.color' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.all.color',
				],
				'module.decoration.border__styles.top.color' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.top.color',
				],
				'module.decoration.border__styles.right.color' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.right.color',
				],
				'module.decoration.border__styles.bottom.color' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.bottom.color',
				],
				'module.decoration.border__styles.left.color' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.left.color',
				],
				'module.decoration.border__styles.all.style' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.all.style',
				],
				'module.decoration.border__styles.top.style' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.top.style',
				],
				'module.decoration.border__styles.right.style' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.right.style',
				],
				'module.decoration.border__styles.bottom.style' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.bottom.style',
				],
				'module.decoration.border__styles.left.style' => [
					'attrName' => 'module.decoration.border',
					'preset'   => [ 'style' ],
					'subName'  => 'styles.left.style',
				],
				'module.decoration.boxShadow__style'       => [
					'attrName' => 'module.decoration.boxShadow',
					'preset'   => [ 'html', 'style' ],
					'subName'  => 'style',
				],
				'module.decoration.boxShadow__horizontal'  => [
					'attrName' => 'module.decoration.boxShadow',
					'preset'   => [
						'html',
						'style',
					],
					'subName'  => 'horizontal',
				],
				'module.decoration.boxShadow__vertical'    => [
					'attrName' => 'module.decoration.boxShadow',
					'preset'   => [
						'html',
						'style',
					],
					'subName'  => 'vertical',
				],
				'module.decoration.boxShadow__blur'        => [
					'attrName' => 'module.decoration.boxShadow',
					'preset'   => [
						'html',
						'style',
					],
					'subName'  => 'blur',
				],
				'module.decoration.boxShadow__spread'      => [
					'attrName' => 'module.decoration.boxShadow',
					'preset'   => [
						'html',
						'style',
					],
					'subName'  => 'spread',
				],
				'module.decoration.boxShadow__color'       => [
					'attrName' => 'module.decoration.boxShadow',
					'preset'   => [
						'html',
						'style',
					],
					'subName'  => 'color',
				],
				'module.decoration.boxShadow__position'    => [
					'attrName' => 'module.decoration.boxShadow',
					'preset'   => [ 'html', 'style' ],
					'subName'  => 'position',
				],
				'module.decoration.filters__hueRotate'     => [
					'attrName' => 'module.decoration.filters',
					'preset'   => [ 'style' ],
					'subName'  => 'hueRotate',
				],
				'module.decoration.filters__saturate'      => [
					'attrName' => 'module.decoration.filters',
					'preset'   => [ 'style' ],
					'subName'  => 'saturate',
				],
				'module.decoration.filters__brightness'    => [
					'attrName' => 'module.decoration.filters',
					'preset'   => [ 'style' ],
					'subName'  => 'brightness',
				],
				'module.decoration.filters__contrast'      => [
					'attrName' => 'module.decoration.filters',
					'preset'   => [ 'style' ],
					'subName'  => 'contrast',
				],
				'module.decoration.filters__invert'        => [
					'attrName' => 'module.decoration.filters',
					'preset'   => [ 'style' ],
					'subName'  => 'invert',
				],
				'module.decoration.filters__sepia'         => [
					'attrName' => 'module.decoration.filters',
					'preset'   => [ 'style' ],
					'subName'  => 'sepia',
				],
				'module.decoration.filters__opacity'       => [
					'attrName' => 'module.decoration.filters',
					'preset'   => [ 'style' ],
					'subName'  => 'opacity',
				],
				'module.decoration.filters__blur'          => [
					'attrName' => 'module.decoration.filters',
					'preset'   => [ 'style' ],
					'subName'  => 'blur',
				],
				'module.decoration.filters__blendMode'     => [
					'attrName' => 'module.decoration.filters',
					'preset'   => [ 'style' ],
					'subName'  => 'blendMode',
				],
				'module.decoration.transform__scale'       => [
					'attrName' => 'module.decoration.transform',
					'preset'   => [ 'style' ],
					'subName'  => 'scale',
				],
				'module.decoration.transform__translate'   => [
					'attrName' => 'module.decoration.transform',
					'preset'   => [ 'style' ],
					'subName'  => 'translate',
				],
				'module.decoration.transform__rotate'      => [
					'attrName' => 'module.decoration.transform',
					'preset'   => [ 'style' ],
					'subName'  => 'rotate',
				],
				'module.decoration.transform__skew'        => [
					'attrName' => 'module.decoration.transform',
					'preset'   => [ 'style' ],
					'subName'  => 'skew',
				],
				'module.decoration.transform__origin'      => [
					'attrName' => 'module.decoration.transform',
					'preset'   => [ 'style' ],
					'subName'  => 'origin',
				],
				'module.decoration.animation__style'       => [
					'attrName' => 'module.decoration.animation',
					'preset'   => [ 'script' ],
					'subName'  => 'style',
				],
				'module.decoration.animation__direction'   => [
					'attrName' => 'module.decoration.animation',
					'preset'   => [ 'script' ],
					'subName'  => 'direction',
				],
				'module.decoration.animation__duration'    => [
					'attrName' => 'module.decoration.animation',
					'preset'   => [ 'script' ],
					'subName'  => 'duration',
				],
				'module.decoration.animation__delay'       => [
					'attrName' => 'module.decoration.animation',
					'preset'   => [ 'script' ],
					'subName'  => 'delay',
				],
				'module.decoration.animation__intensity.slide' => [
					'attrName' => 'module.decoration.animation',
					'preset'   => [ 'script' ],
					'subName'  => 'intensity.slide',
				],
				'module.decoration.animation__intensity.zoom' => [
					'attrName' => 'module.decoration.animation',
					'preset'   => [ 'script' ],
					'subName'  => 'intensity.zoom',
				],
				'module.decoration.animation__intensity.flip' => [
					'attrName' => 'module.decoration.animation',
					'preset'   => [ 'script' ],
					'subName'  => 'intensity.flip',
				],
				'module.decoration.animation__intensity.fold' => [
					'attrName' => 'module.decoration.animation',
					'preset'   => [ 'script' ],
					'subName'  => 'intensity.fold',
				],
				'module.decoration.animation__intensity.roll' => [
					'attrName' => 'module.decoration.animation',
					'preset'   => [ 'script' ],
					'subName'  => 'intensity.roll',
				],
				'module.decoration.animation__startingOpacity' => [
					'attrName' => 'module.decoration.animation',
					'preset'   => [ 'script' ],
					'subName'  => 'startingOpacity',
				],
				'module.decoration.animation__speedCurve'  => [
					'attrName' => 'module.decoration.animation',
					'preset'   => [ 'script' ],
					'subName'  => 'speedCurve',
				],
				'module.decoration.animation__repeat'      => [
					'attrName' => 'module.decoration.animation',
					'preset'   => [ 'script' ],
					'subName'  => 'repeat',
				],
				'module.advanced.htmlAttributes__id'       => [
					'attrName' => 'module.advanced.htmlAttributes',
					'preset'   => 'content',
					'subName'  => 'id',
				],
				'module.advanced.elements.structure'       => [
					'attrName' => 'module.advanced.elements.structure',
					'preset'   => 'content',
				],
				'module.advanced.htmlAttributes__class'    => [
					'attrName' => 'module.advanced.htmlAttributes',
					'preset'   => [ 'html' ],
					'subName'  => 'class',
				],
				'css__before'                              => [
					'attrName' => 'css',
					'preset'   => [ 'style' ],
					'subName'  => 'before',
				],
				'css__mainElement'                         => [
					'attrName' => 'css',
					'preset'   => [ 'style' ],
					'subName'  => 'mainElement',
				],
				'css__after'                               => [
					'attrName' => 'css',
					'preset'   => [ 'style' ],
					'subName'  => 'after',
				],
				'css__freeForm'                            => [
					'attrName' => 'css',
					'preset'   => [ 'style' ],
					'subName'  => 'freeForm',
				],
				'css__tabsControls'                        => [
					'attrName' => 'css',
					'preset'   => [ 'style' ],
					'subName'  => 'tabsControls',
				],
				'css__tab'                                 => [
					'attrName' => 'css',
					'preset'   => [ 'style' ],
					'subName'  => 'tab',
				],
				'css__activeTab'                           => [
					'attrName' => 'css',
					'preset'   => [ 'style' ],
					'subName'  => 'activeTab',
				],
				'css__tabsContent'                         => [
					'attrName' => 'css',
					'preset'   => [ 'style' ],
					'subName'  => 'tabsContent',
				],
				'module.decoration.conditions'             => [
					'attrName' => 'module.decoration.conditions',
					'preset'   => [ 'html' ],
				],
				'module.decoration.disabledOn'             => [
					'attrName' => 'module.decoration.disabledOn',
					'preset'   => [ 'style', 'html' ],
				],
				'module.decoration.interactions'           => [
					'attrName' => 'module.decoration.interactions',
					'preset'   => [ 'script' ],
				],
				'module.decoration.overflow__x'            => [
					'attrName' => 'module.decoration.overflow',
					'preset'   => [ 'style' ],
					'subName'  => 'x',
				],
				'module.decoration.overflow__y'            => [
					'attrName' => 'module.decoration.overflow',
					'preset'   => [ 'style' ],
					'subName'  => 'y',
				],
				'module.decoration.transition__duration'   => [
					'attrName' => 'module.decoration.transition',
					'preset'   => [ 'style' ],
					'subName'  => 'duration',
				],
				'module.decoration.transition__delay'      => [
					'attrName' => 'module.decoration.transition',
					'preset'   => [ 'style' ],
					'subName'  => 'delay',
				],
				'module.decoration.transition__speedCurve' => [
					'attrName' => 'module.decoration.transition',
					'preset'   => [ 'style' ],
					'subName'  => 'speedCurve',
				],
				'module.decoration.position__mode'         => [
					'attrName' => 'module.decoration.position',
					'preset'   => [ 'style' ],
					'subName'  => 'mode',
				],
				'module.decoration.position__origin.relative' => [
					'attrName' => 'module.decoration.position',
					'preset'   => [ 'style' ],
					'subName'  => 'origin.relative',
				],
				'module.decoration.position__origin.absolute' => [
					'attrName' => 'module.decoration.position',
					'preset'   => [ 'style' ],
					'subName'  => 'origin.absolute',
				],
				'module.decoration.position__origin.fixed' => [
					'attrName' => 'module.decoration.position',
					'preset'   => [ 'style' ],
					'subName'  => 'origin.fixed',
				],
				'module.decoration.position__offset.vertical' => [
					'attrName' => 'module.decoration.position',
					'preset'   => [ 'style' ],
					'subName'  => 'offset.vertical',
				],
				'module.decoration.position__offset.horizontal' => [
					'attrName' => 'module.decoration.position',
					'preset'   => [ 'style' ],
					'subName'  => 'offset.horizontal',
				],
				'module.decoration.zIndex'                 => [
					'attrName' => 'module.decoration.zIndex',
					'preset'   => [ 'style' ],
				],
				'module.decoration.scroll__verticalMotion.enable' => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'verticalMotion.enable',
				],
				'module.decoration.scroll__horizontalMotion.enable' => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'horizontalMotion.enable',
				],
				'module.decoration.scroll__fade.enable'    => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'fade.enable',
				],
				'module.decoration.scroll__scaling.enable' => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'scaling.enable',
				],
				'module.decoration.scroll__rotating.enable' => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'rotating.enable',
				],
				'module.decoration.scroll__blur.enable'    => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'blur.enable',
				],
				'module.decoration.scroll__verticalMotion' => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'verticalMotion',
				],
				'module.decoration.scroll__horizontalMotion' => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'horizontalMotion',
				],
				'module.decoration.scroll__fade'           => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'fade',
				],
				'module.decoration.scroll__scaling'        => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'scaling',
				],
				'module.decoration.scroll__rotating'       => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'rotating',
				],
				'module.decoration.scroll__blur'           => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'blur',
				],
				'module.decoration.scroll__motionTriggerStart' => [
					'attrName' => 'module.decoration.scroll',
					'preset'   => [ 'script' ],
					'subName'  => 'motionTriggerStart',
				],
				'module.decoration.sticky__position'       => [
					'attrName' => 'module.decoration.sticky',
					'preset'   => [ 'script' ],
					'subName'  => 'position',
				],
				'module.decoration.sticky__offset.top'     => [
					'attrName' => 'module.decoration.sticky',
					'preset'   => [ 'script' ],
					'subName'  => 'offset.top',
				],
				'module.decoration.sticky__offset.bottom'  => [
					'attrName' => 'module.decoration.sticky',
					'preset'   => [ 'script' ],
					'subName'  => 'offset.bottom',
				],
				'module.decoration.sticky__limit.top'      => [
					'attrName' => 'module.decoration.sticky',
					'preset'   => [ 'script' ],
					'subName'  => 'limit.top',
				],
				'module.decoration.sticky__limit.bottom'   => [
					'attrName' => 'module.decoration.sticky',
					'preset'   => [ 'script' ],
					'subName'  => 'limit.bottom',
				],
				'module.decoration.sticky__offset.surrounding' => [
					'attrName' => 'module.decoration.sticky',
					'preset'   => [ 'script' ],
					'subName'  => 'offset.surrounding',
				],
				'module.decoration.sticky__transition'     => [
					'attrName' => 'module.decoration.sticky',
					'preset'   => [ 'script' ],
					'subName'  => 'transition',
				],
				'module.decoration.attributes'             => [
					'attrName' => 'module.decoration.attributes',
					'preset'   => [ 'html' ],
				],
			],
			$loop_preset_attrs
		);
	}
}
