import { getOption, setOption, saveOptions } from "@/helpers/common";


const languages = {
    namespaced: true,
    state: {
        selected: [],
        available: window.wccLanguages,
        current: '',
        default: ''
    },

    getters: {
        getSelected: (state) => {
            return state.selected
        },
        getCurrent: (state) => {
            return state.current;
        },
        getAvailable: (state) => {
            return state.available;
        },
        getDefault: (state) => {
            return state.available.find(function (langage) {
                return langage.code == state.default;
            });
        },
    },

    mutations: {
        /**
         * Update a single value in store.
         *
         * Updates the value only on store.
         * Call updateSettings mutation to store the values in db.
         *
         * @param {object} state Current state.
         * @param {object} data Data to update.
         */
        setSelected: (state, data) => {
            state.selected = data
        },
        setCurrent: (state, data) => {
            state.current = data
        },
        setAvailable: (state, data) => {
            state.available = data
        },
        setDefault: (state, data) => {
            state.default = data
        },
    },

    actions: {
        /**
         * Set a single option value after validation.
         *
         * Make sure all required items are provided, then
         * call the mutation.
         *
         * @param commit Commit.
         * @param {object} data Custom params.
         */
        setSelected: async ({ commit }, data = {}) => {
            commit('setSelected', data)
        },
        setCurrent: async ({ commit }, data = {}) => {
            commit('setCurrent', data)
        },
        setDefault: async ({ commit }, data = {}) => {
            commit('setDefault', data)
        },
        /**
         * Update the settings values in db.
         *
         * Use the API and update the whole values.
         * Only do this when required.
         *
         * @param {object} Commit and State.
         * @param {object} data Custom params.
         *
         * @return {boolean}
         */
        saveSelected: async ({ state }) => {
            const data = state.selected;
            let languages = getOption('languages');
            languages.selected = data;
            setOption('languages', languages);
            return await saveOptions();
        },
        saveDefault: async ({ state }) => {
            const data = state.default;
            let languages = getOption('languages');
            languages.default = data;
            setOption('languages', languages);
            return await saveOptions();
        },
        loadLanguages: async ({ commit }) => {
            const data = getOption('languages');
            commit('setSelected', data.selected);
            commit('setDefault', data.default);
            commit('setCurrent', data.default);
        },

    },
}
export default languages
